<?php
// years.php — Lista los años y db_name para un tenant (por code)
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
require_once __DIR__ . '/config.php';

$code = isset($_GET['code']) ? strtolower(trim($_GET['code'])) : '';
if ($code === '') { http_response_code(400); echo json_encode(['ok'=>false,'error'=>'Falta parámetro code']); exit; }

try {
  $pdo = new PDO("mysql:host={$DB_HOST};dbname={$DB_NAME};charset={$DB_CHARSET}", $DB_USER, $DB_PASS, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);

  $q = $pdo->prepare("SELECT id FROM tenants WHERE code = :c AND active = 1 LIMIT 1");
  $q->execute([':c' => $code]);
  $row = $q->fetch(PDO::FETCH_ASSOC);
  if (!$row) { http_response_code(404); echo json_encode(['ok'=>false,'error'=>'Colegió no encontrado']); exit; }

  $q2 = $pdo->prepare("SELECT year, db_name FROM tenant_years WHERE tenant_id = :tid ORDER BY year DESC");
  $q2->execute([':tid' => $row['id']]);
  $years = $q2->fetchAll(PDO::FETCH_ASSOC);

  echo json_encode(['ok'=>true, 'years'=>$years]);
} catch (Exception $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false,'error'=>'Error interno']); exit;
}
